/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.AbstractProtocol;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.features.Location;
import ch.cyberduck.core.io.HashAlgorithm;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.s3.S3LocationFeature;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public final class S3Protocol
extends AbstractProtocol {
    private static final Logger log = Logger.getLogger(S3Protocol.class);

    public String getName() {
        return "S3";
    }

    public String getDescription() {
        return LocaleFactory.localizedString((String)"Amazon S3", (String)"S3");
    }

    public String getIdentifier() {
        return "s3";
    }

    public Scheme getScheme() {
        return Scheme.https;
    }

    public String[] getSchemes() {
        return new String[]{this.getScheme().name(), "s3"};
    }

    public boolean isHostnameConfigurable() {
        return true;
    }

    public boolean isPortConfigurable() {
        return true;
    }

    public String getDefaultHostname() {
        return "s3.amazonaws.com";
    }

    public Set<Location.Name> getRegions() {
        return new HashSet<Location.Name>(Arrays.asList(new S3LocationFeature.S3Region("us-east-1"), new S3LocationFeature.S3Region("us-east-2"), new S3LocationFeature.S3Region("us-west-1"), new S3LocationFeature.S3Region("us-west-2"), new S3LocationFeature.S3Region("ca-central-1"), new S3LocationFeature.S3Region("eu-west-1"), new S3LocationFeature.S3Region("eu-west-2"), new S3LocationFeature.S3Region("eu-central-1"), new S3LocationFeature.S3Region("ap-southeast-1"), new S3LocationFeature.S3Region("ap-southeast-2"), new S3LocationFeature.S3Region("ap-northeast-1"), new S3LocationFeature.S3Region("ap-northeast-2"), new S3LocationFeature.S3Region("ap-south-1"), new S3LocationFeature.S3Region("sa-east-1")));
    }

    public String getUsernamePlaceholder() {
        return LocaleFactory.localizedString((String)"Access Key ID", (String)"S3");
    }

    public String getPasswordPlaceholder() {
        return LocaleFactory.localizedString((String)"Secret Access Key", (String)"S3");
    }

    public String favicon() {
        return this.icon();
    }

    public String getAuthorization() {
        return PreferencesFactory.get().getProperty("s3.signature.version");
    }

    public static enum AuthenticationHeaderSignatureVersion {
        AWS2{

            @Override
            public HashAlgorithm getHashAlgorithm() {
                return HashAlgorithm.sha1;
            }
        }
        ,
        AWS4HMACSHA256{

            @Override
            public HashAlgorithm getHashAlgorithm() {
                return HashAlgorithm.sha256;
            }

            public String toString() {
                return "AWS4-HMAC-SHA256";
            }
        };


        public static AuthenticationHeaderSignatureVersion getDefault(Protocol protocol) {
            try {
                return AuthenticationHeaderSignatureVersion.valueOf(protocol.getAuthorization());
            }
            catch (IllegalArgumentException e) {
                log.warn((Object)String.format("Unsupported authentication context %s", protocol.getAuthorization()));
                return AuthenticationHeaderSignatureVersion.valueOf(PreferencesFactory.get().getProperty("s3.signature.version"));
            }
        }

        public abstract HashAlgorithm getHashAlgorithm();
    }
}

