/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.features.Versioning;
import ch.cyberduck.core.http.HttpRange;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.jets3t.service.ServiceException;
import org.jets3t.service.model.S3Object;

public class S3ReadFeature
implements Read {
    private static final Logger log = Logger.getLogger(S3ReadFeature.class);
    private final PathContainerService containerService = new S3PathContainerService();
    private final S3Session session;
    private final Versioning versioning;

    public S3ReadFeature(S3Session session) {
        this(session, (Versioning)session.getFeature(Versioning.class));
    }

    public S3ReadFeature(S3Session session, Versioning versioning) {
        this.session = session;
        this.versioning = versioning;
    }

    public InputStream read(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            HttpRange range = HttpRange.withStatus((TransferStatus)status);
            RequestEntityRestStorageService client = (RequestEntityRestStorageService)((Object)this.session.getClient());
            S3Object object = this.versioning != null && this.versioning.getConfiguration(this.containerService.getContainer(file)).isEnabled() ? client.getVersionedObject(file.attributes().getVersionId(), this.containerService.getContainer(file).getName(), this.containerService.getKey(file), null, null, null, null, status.isAppend() ? Long.valueOf(range.getStart()) : null, status.isAppend() ? (range.getEnd() == -1L ? null : Long.valueOf(range.getEnd())) : null) : client.getObject(this.containerService.getContainer(file).getName(), this.containerService.getKey(file), null, null, null, null, status.isAppend() ? Long.valueOf(range.getStart()) : null, status.isAppend() ? (range.getEnd() == -1L ? null : Long.valueOf(range.getEnd())) : null);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Reading stream with content length %d", object.getContentLength()));
            }
            return object.getDataInputStream();
        }
        catch (ServiceException e) {
            throw new S3ExceptionMappingService().map("Download {0} failed", e, file);
        }
    }

    public boolean offset(Path file) {
        return true;
    }
}

