/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Search;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3ObjectListService;
import ch.cyberduck.core.s3.S3Session;
import java.io.IOException;
import org.jets3t.service.ServiceException;

public class S3SearchFeature
implements Search {
    private final S3Session session;

    public S3SearchFeature(S3Session session) {
        this.session = session;
    }

    public AttributedList<Path> search(Path workdir, Filter<Path> regex, ListProgressListener listener) throws BackgroundException {
        S3ObjectListService list = new S3ObjectListService(this.session);
        try {
            return list.listObjects(workdir, String.format("%s%s", list.createPrefix(workdir), regex.toPattern().pattern()), listener);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Failure to read attributes of {0}", (Throwable)e, workdir);
        }
        catch (ServiceException e) {
            throw new S3ExceptionMappingService().map("Failure to read attributes of {0}", e, workdir);
        }
    }

    public boolean isRecursive() {
        return false;
    }

    public Search withCache(Cache<Path> cache) {
        return this;
    }
}

