/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledConnectionCallback;
import ch.cyberduck.core.DisabledHostKeyCallback;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.HostParser;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.dav.DAVReadFeature;
import ch.cyberduck.core.dav.DAVSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.transfer.TransferStatus;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.MalformedJsonException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.EnumSet;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.security.AWSSessionCredentials;

public class S3SessionCredentialsRetriever {
    private final TranscriptListener transcript;
    private final ProtocolFactory factory;
    private final String url;
    private final X509TrustManager trust;
    private final X509KeyManager key;

    public S3SessionCredentialsRetriever(X509TrustManager trust, X509KeyManager key, TranscriptListener transcript, String url) {
        this(trust, key, ProtocolFactory.global, transcript, url);
    }

    public S3SessionCredentialsRetriever(X509TrustManager trust, X509KeyManager key, ProtocolFactory factory, TranscriptListener transcript, String url) {
        this.trust = trust;
        this.key = key;
        this.factory = factory;
        this.transcript = transcript;
        this.url = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AWSCredentials get() throws BackgroundException {
        Host address = new HostParser(this.factory).get(this.url);
        Path access = new Path(address.getDefaultPath(), EnumSet.of(AbstractPath.Type.file));
        address.setDefaultPath(String.valueOf('/'));
        DAVSession connection = new DAVSession(address, this.trust, this.key);
        connection.withListener(this.transcript).open((HostKeyCallback)new DisabledHostKeyCallback());
        InputStream in = new DAVReadFeature(connection).read(access, new TransferStatus(), (ConnectionCallback)new DisabledConnectionCallback());
        try {
            AWSCredentials credentials = this.parse(in);
            connection.close();
            AWSCredentials aWSCredentials = credentials;
            return aWSCredentials;
        }
        finally {
            connection.removeListener(this.transcript);
        }
    }

    protected AWSCredentials parse(InputStream in) throws BackgroundException {
        try {
            JsonReader reader = new JsonReader((Reader)new InputStreamReader(in, "UTF-8"));
            reader.beginObject();
            String key = null;
            String secret = null;
            String token = null;
            while (reader.hasNext()) {
                String name = reader.nextName();
                String value = reader.nextString();
                switch (name) {
                    case "AccessKeyId": {
                        key = value;
                        break;
                    }
                    case "SecretAccessKey": {
                        secret = value;
                        break;
                    }
                    case "Token": {
                        token = value;
                    }
                }
            }
            reader.endObject();
            return new AWSSessionCredentials(key, secret, token);
        }
        catch (UnsupportedEncodingException e) {
            throw new DefaultIOExceptionMappingService().map((IOException)e);
        }
        catch (MalformedJsonException e) {
            throw new InteroperabilityException("Invalid JSON response", (Throwable)e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public String getUrl() {
        return this.url;
    }
}

