/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Encryption;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.s3.S3AccessControlListFeature;
import ch.cyberduck.core.s3.S3CopyFeature;
import ch.cyberduck.core.s3.S3MultipartCopyFeature;
import ch.cyberduck.core.s3.S3Session;

public class S3ThresholdCopyFeature
extends S3CopyFeature {
    private final Preferences preferences = PreferencesFactory.get();
    private final S3Session session;
    private final S3AccessControlListFeature accessControlListFeature;
    private final Long multipartThreshold = this.preferences.getLong("s3.upload.multipart.threshold");

    public S3ThresholdCopyFeature(S3Session session, S3AccessControlListFeature accessControlListFeature) {
        super(session, accessControlListFeature);
        this.session = session;
        this.accessControlListFeature = accessControlListFeature;
    }

    @Override
    protected void copy(Path source, Path copy, String storageClass, Encryption.Algorithm encryption, Acl acl) throws BackgroundException {
        if (source.attributes().getSize() > this.multipartThreshold) {
            new S3MultipartCopyFeature(this.session, this.accessControlListFeature).copy(source, copy, storageClass, encryption, acl);
        } else {
            new S3CopyFeature(this.session, this.accessControlListFeature).copy(source, copy, storageClass, encryption, acl);
        }
    }
}

