/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledConnectionCallback;
import ch.cyberduck.core.MappingMimeTypeService;
import ch.cyberduck.core.MimeTypeService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Encryption;
import ch.cyberduck.core.features.Redundancy;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.DefaultStreamCloser;
import ch.cyberduck.core.s3.S3DisabledMultipartService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.s3.S3WriteFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.input.NullInputStream;
import org.jets3t.service.model.StorageObject;

public class S3TouchFeature
implements Touch<StorageObject> {
    private final S3Session session;
    private final MimeTypeService mapping = new MappingMimeTypeService();
    private Write writer;

    public S3TouchFeature(S3Session session) {
        this.session = session;
        this.writer = new S3WriteFeature(session, new S3DisabledMultipartService());
    }

    public Path touch(Path file, TransferStatus status) throws BackgroundException {
        Redundancy redundancy;
        Encryption encryption;
        status.setMime(this.mapping.getMime(file.getName()));
        if (Encryption.Algorithm.NONE == status.getEncryption() && (encryption = (Encryption)this.session.getFeature(Encryption.class)) != null) {
            status.setEncryption(encryption.getDefault(file));
        }
        if (null == status.getStorageClass() && (redundancy = (Redundancy)this.session.getFeature(Redundancy.class)) != null) {
            status.setStorageClass(redundancy.getDefault());
        }
        if (Checksum.NONE == status.getChecksum()) {
            status.setChecksum(this.writer.checksum().compute((InputStream)new NullInputStream(0L), status.length(0L)));
        }
        status.setLength(0L);
        new DefaultStreamCloser().close((OutputStream)this.writer.write(file, status, (ConnectionCallback)new DisabledConnectionCallback()));
        return file;
    }

    public boolean isSupported(Path workdir) {
        return !workdir.isRoot();
    }

    public Touch<StorageObject> withWriter(Write writer) {
        this.writer = writer;
        return this;
    }
}

