/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.spectra;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.s3.S3DirectoryFeature;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.spectra.SpectraSession;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.InputStream;
import org.apache.commons.io.input.NullInputStream;
import org.jets3t.service.model.StorageObject;

public class SpectraDirectoryFeature
extends S3DirectoryFeature {
    private final PathContainerService containerService = new S3PathContainerService();
    private final Write<StorageObject> writer;

    public SpectraDirectoryFeature(SpectraSession session, Write<StorageObject> writer) {
        super((S3Session)session, writer);
        this.writer = writer;
    }

    public Path mkdir(Path folder, String region, TransferStatus status) throws BackgroundException {
        if (this.containerService.isContainer(folder)) {
            super.mkdir(folder, region, status);
        } else {
            if (Checksum.NONE == status.getChecksum()) {
                status.setChecksum(this.writer.checksum().compute((InputStream)new NullInputStream(0L), status));
            }
            super.mkdir(folder, region, status);
        }
        return folder;
    }

    public boolean isSupported(Path workdir) {
        return true;
    }
}

