/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.spectra;

import ch.cyberduck.core.AbstractProtocol;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.s3.S3Protocol;

public class SpectraProtocol
extends AbstractProtocol {
    public String getName() {
        return "Spectra S3";
    }

    public String getDescription() {
        return LocaleFactory.localizedString((String)"Spectra BlackPearl Deep Storage Gateway (HTTPS)", (String)"S3");
    }

    public String getIdentifier() {
        return "spectra";
    }

    public boolean isPortConfigurable() {
        return true;
    }

    public Scheme getScheme() {
        return Scheme.https;
    }

    public Protocol.Type getType() {
        return Protocol.Type.s3;
    }

    public String getPrefix() {
        return String.format("%s.%s", SpectraProtocol.class.getPackage().getName(), "Spectra");
    }

    public boolean isHostnameConfigurable() {
        return true;
    }

    public String getUsernamePlaceholder() {
        return LocaleFactory.localizedString((String)"Access Key ID", (String)"S3");
    }

    public String getPasswordPlaceholder() {
        return LocaleFactory.localizedString((String)"Secret Access Key", (String)"S3");
    }

    public String disk() {
        return String.format("%s.tiff", "ftp");
    }

    public boolean isEnabled() {
        return false;
    }

    public String getAuthorization() {
        return S3Protocol.AuthenticationHeaderSignatureVersion.AWS2.name();
    }
}

