/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.spectra;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.spectra.SpectraBulkService;
import ch.cyberduck.core.spectra.SpectraSession;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.Collections;
import java.util.Map;

public class SpectraTouchFeature
implements Touch {
    private final SpectraSession session;

    public SpectraTouchFeature(SpectraSession session) {
        this.session = session;
    }

    public Path touch(Path file, TransferStatus transferStatus) throws BackgroundException {
        SpectraBulkService bulk = new SpectraBulkService(this.session);
        TransferStatus status = new TransferStatus();
        bulk.pre(Transfer.Type.upload, (Map)Collections.singletonMap(file, status.length(0L)), (ConnectionCallback)new DisabledConnectionCallback());
        return file;
    }

    public boolean isSupported(Path workdir) {
        return !workdir.isRoot();
    }

    public SpectraTouchFeature withWriter(Write writer) {
        return this;
    }
}

