/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.spectra;

import ch.cyberduck.core.Session;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.io.ChecksumComputeFactory;
import ch.cyberduck.core.io.HashAlgorithm;
import ch.cyberduck.core.s3.S3DisabledMultipartService;
import ch.cyberduck.core.s3.S3MultipartService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.s3.S3WriteFeature;
import ch.cyberduck.core.shared.DefaultAttributesFinderFeature;
import ch.cyberduck.core.shared.DefaultFindFeature;
import ch.cyberduck.core.spectra.SpectraSession;
import ch.cyberduck.core.transfer.TransferStatus;
import org.jets3t.service.model.S3Object;

public class SpectraWriteFeature
extends S3WriteFeature {
    public SpectraWriteFeature(SpectraSession session) {
        this(session, (Find)new DefaultFindFeature((Session)session), (AttributesFinder)new DefaultAttributesFinderFeature((Session)session));
    }

    public SpectraWriteFeature(SpectraSession session, Find finder, AttributesFinder attributes) {
        super((S3Session)session, (S3MultipartService)new S3DisabledMultipartService(), finder, attributes);
    }

    protected S3Object getDetails(String key, TransferStatus status) {
        S3Object object = super.getDetails(key, status);
        Checksum checksum = status.getChecksum();
        if (Checksum.NONE != checksum) {
            switch (checksum.algorithm) {
                case crc32: {
                    object.addMetadata("Content-CRC32", checksum.hash);
                }
            }
        }
        return object;
    }

    public ChecksumCompute checksum() {
        return ChecksumComputeFactory.get((HashAlgorithm)HashAlgorithm.crc32);
    }
}

