/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dav;

import com.github.sardine.impl.SardineImpl;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.HttpClientBuilder;

public class DAVClient
extends SardineImpl {
    private final String uri;

    public DAVClient(String uri, HttpClientBuilder http) {
        super(http);
        this.uri = uri;
    }

    public <T> T execute(HttpRequestBase request, ResponseHandler<T> responseHandler) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)request.getURI().getRawQuery())) {
            request.setURI(URI.create(String.format("%s%s?%s", this.uri, request.getURI().getRawPath(), request.getURI().getRawQuery())));
        } else {
            request.setURI(URI.create(String.format("%s%s", this.uri, request.getURI().getRawPath())));
        }
        return (T)super.execute(request, responseHandler);
    }

    protected HttpResponse execute(HttpRequestBase request) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)request.getURI().getRawQuery())) {
            request.setURI(URI.create(String.format("%s%s?%s", this.uri, request.getURI().getRawPath(), request.getURI().getRawQuery())));
        } else {
            request.setURI(URI.create(String.format("%s%s", this.uri, request.getURI().getRawPath())));
        }
        return super.execute(request);
    }

    public HttpClientContext context() {
        return this.context;
    }
}

