/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dav;

import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.dav.DAVClient;
import ch.cyberduck.core.dav.DAVExceptionMappingService;
import ch.cyberduck.core.dav.DAVPathEncoder;
import ch.cyberduck.core.dav.DAVSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.http.HttpExceptionMappingService;
import ch.cyberduck.core.shared.DefaultUrlProvider;
import ch.cyberduck.core.transfer.TransferStatus;
import com.github.sardine.impl.SardineException;
import java.io.IOException;

public class DAVCopyFeature
implements Copy {
    private final DAVSession session;

    public DAVCopyFeature(DAVSession session) {
        this.session = session;
    }

    public void copy(Path source, Path copy, TransferStatus status) throws BackgroundException {
        try {
            String target = new DefaultUrlProvider(this.session.getHost()).toUrl(copy).find(DescriptiveUrl.Type.provider).getUrl();
            ((DAVClient)((Object)this.session.getClient())).copy(new DAVPathEncoder().encode(source), target);
        }
        catch (SardineException e) {
            throw new DAVExceptionMappingService().map("Cannot copy {0}", e, source);
        }
        catch (IOException e) {
            throw new HttpExceptionMappingService().map(e, source);
        }
    }

    public boolean isRecursive(Path source, Path target) {
        return true;
    }

    public boolean isSupported(Path source, Path target) {
        return true;
    }
}

