/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dav;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.dav.DAVClient;
import ch.cyberduck.core.dav.DAVExceptionMappingService;
import ch.cyberduck.core.dav.DAVPathEncoder;
import ch.cyberduck.core.dav.DAVSession;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.LoginFailureException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.http.HttpExceptionMappingService;
import com.github.sardine.impl.SardineException;
import java.io.IOException;

public class DAVFindFeature
implements Find {
    private final DAVSession session;
    private Cache<Path> cache;

    public DAVFindFeature(DAVSession session) {
        this.session = session;
        this.cache = PathCache.empty();
    }

    public boolean find(Path file) throws BackgroundException {
        AttributedList list;
        if (file.isRoot()) {
            return true;
        }
        if (this.cache.isCached((Referenceable)file.getParent())) {
            list = this.cache.get((Referenceable)file.getParent());
        } else {
            list = new AttributedList();
            this.cache.put((Referenceable)file.getParent(), list);
        }
        if (list.contains((Referenceable)file)) {
            return true;
        }
        if (this.cache.isHidden((Referenceable)file)) {
            return false;
        }
        try {
            try {
                boolean found = ((DAVClient)((Object)this.session.getClient())).exists(new DAVPathEncoder().encode(file));
                if (found) {
                    list.add((Referenceable)file);
                } else {
                    list.attributes().addHidden((Object)file);
                }
                return found;
            }
            catch (SardineException e) {
                throw new DAVExceptionMappingService().map("Failure to read attributes of {0}", e, file);
            }
            catch (IOException e) {
                throw new HttpExceptionMappingService().map(e, file);
            }
        }
        catch (AccessDeniedException e) {
            return true;
        }
        catch (LoginFailureException | NotfoundException e) {
            return false;
        }
    }

    public Find withCache(Cache<Path> cache) {
        this.cache = cache;
        return this;
    }
}

