/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dav;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.dav.DAVClient;
import ch.cyberduck.core.dav.DAVExceptionMappingService;
import ch.cyberduck.core.dav.DAVPathEncoder;
import ch.cyberduck.core.dav.DAVSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Quota;
import ch.cyberduck.core.shared.DefaultHomeFinderService;
import com.github.sardine.DavQuota;
import com.github.sardine.impl.SardineException;
import java.io.IOException;

public class DAVQuotaFeature
implements Quota {
    private final DAVSession session;

    public DAVQuotaFeature(DAVSession session) {
        this.session = session;
    }

    public Quota.Space get() throws BackgroundException {
        Path home = new DefaultHomeFinderService((Session)this.session).find();
        try {
            DavQuota quota = ((DAVClient)((Object)this.session.getClient())).getQuota(new DAVPathEncoder().encode(home));
            return new Quota.Space(Long.valueOf(quota.getQuotaUsedBytes() > 0L ? quota.getQuotaUsedBytes() : 0L), Long.valueOf(quota.getQuotaAvailableBytes() > 0L ? quota.getQuotaAvailableBytes() : Long.MAX_VALUE));
        }
        catch (SardineException e) {
            throw new DAVExceptionMappingService().map("Failure to read attributes of {0}", e, home);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e, home);
        }
    }
}

