/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dav;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.HostPasswordStore;
import ch.cyberduck.core.HostUrlProvider;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.dav.DAVAttributesFinderFeature;
import ch.cyberduck.core.dav.DAVClient;
import ch.cyberduck.core.dav.DAVCopyFeature;
import ch.cyberduck.core.dav.DAVDeleteFeature;
import ch.cyberduck.core.dav.DAVDirectoryFeature;
import ch.cyberduck.core.dav.DAVExceptionMappingService;
import ch.cyberduck.core.dav.DAVListService;
import ch.cyberduck.core.dav.DAVLockFeature;
import ch.cyberduck.core.dav.DAVMetadataFeature;
import ch.cyberduck.core.dav.DAVMoveFeature;
import ch.cyberduck.core.dav.DAVPathEncoder;
import ch.cyberduck.core.dav.DAVQuotaFeature;
import ch.cyberduck.core.dav.DAVReadFeature;
import ch.cyberduck.core.dav.DAVRedirectStrategy;
import ch.cyberduck.core.dav.DAVSSLProtocol;
import ch.cyberduck.core.dav.DAVTimestampFeature;
import ch.cyberduck.core.dav.DAVUploadFeature;
import ch.cyberduck.core.dav.DAVWriteFeature;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.exception.ListCanceledException;
import ch.cyberduck.core.exception.LoginCanceledException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Headers;
import ch.cyberduck.core.features.Lock;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.Quota;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.features.Timestamp;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpExceptionMappingService;
import ch.cyberduck.core.http.HttpSession;
import ch.cyberduck.core.http.PreferencesRedirectCallback;
import ch.cyberduck.core.http.RedirectCallback;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.proxy.ProxyFinder;
import ch.cyberduck.core.shared.DefaultHomeFinderService;
import ch.cyberduck.core.shared.DefaultTouchFeature;
import ch.cyberduck.core.ssl.DefaultX509KeyManager;
import ch.cyberduck.core.ssl.DisabledX509TrustManager;
import ch.cyberduck.core.ssl.ThreadLocalHostnameDelegatingTrustManager;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.threading.CancelCallback;
import com.github.sardine.impl.SardineException;
import com.github.sardine.impl.handler.ValidatingResponseHandler;
import com.github.sardine.impl.handler.VoidResponseHandler;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import javax.net.SocketFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.log4j.Logger;

public class DAVSession
extends HttpSession<DAVClient> {
    private static final Logger log = Logger.getLogger(DAVSession.class);
    private RedirectCallback redirect = new PreferencesRedirectCallback();
    private final Preferences preferences = PreferencesFactory.get();

    public DAVSession(Host host) {
        super(host, new ThreadLocalHostnameDelegatingTrustManager((X509TrustManager)new DisabledX509TrustManager(), host.getHostname()), (X509KeyManager)new DefaultX509KeyManager());
    }

    public DAVSession(Host host, X509TrustManager trust, X509KeyManager key) {
        super(host, new ThreadLocalHostnameDelegatingTrustManager(trust, host.getHostname()), key);
    }

    public DAVSession(Host host, RedirectCallback redirect) {
        super(host, new ThreadLocalHostnameDelegatingTrustManager((X509TrustManager)new DisabledX509TrustManager(), host.getHostname()), (X509KeyManager)new DefaultX509KeyManager());
        this.redirect = redirect;
    }

    public DAVSession(Host host, X509TrustManager trust, X509KeyManager key, RedirectCallback redirect) {
        super(host, new ThreadLocalHostnameDelegatingTrustManager(trust, host.getHostname()), key);
        this.redirect = redirect;
    }

    public DAVSession(Host host, X509TrustManager trust, X509KeyManager key, SocketFactory socketFactory) {
        super(host, new ThreadLocalHostnameDelegatingTrustManager(trust, host.getHostname()), key, socketFactory);
    }

    public DAVSession(Host host, X509TrustManager trust, X509KeyManager key, ProxyFinder proxy) {
        super(host, new ThreadLocalHostnameDelegatingTrustManager(trust, host.getHostname()), key, proxy);
    }

    public DAVSession(Host host, X509TrustManager trust, X509KeyManager key, SocketFactory socketFactory, RedirectCallback redirect) {
        super(host, new ThreadLocalHostnameDelegatingTrustManager(trust, host.getHostname()), key, socketFactory);
        this.redirect = redirect;
    }

    public DAVClient connect(HostKeyCallback key) throws BackgroundException {
        HttpClientBuilder pool = this.builder.build((TranscriptListener)this);
        pool.setRedirectStrategy((RedirectStrategy)new DAVRedirectStrategy(this.redirect));
        return new DAVClient(new HostUrlProvider(false).get(this.host), pool);
    }

    protected void logout() throws BackgroundException {
        try {
            ((DAVClient)((Object)this.client)).shutdown();
        }
        catch (IOException e) {
            throw new HttpExceptionMappingService().map(e);
        }
    }

    public void login(HostPasswordStore keychain, LoginCallback prompt, final CancelCallback cancel, Cache<Path> cache) throws BackgroundException {
        ((DAVClient)((Object)this.client)).setCredentials(this.host.getCredentials().getUsername(), this.host.getCredentials().getPassword(), this.preferences.getProperty("webdav.ntlm.workstation"), this.preferences.getProperty("webdav.ntlm.domain"));
        if (this.preferences.getBoolean("webdav.basic.preemptive")) {
            ((DAVClient)((Object)this.client)).enablePreemptiveAuthentication(this.host.getHostname(), this.host.getPort(), this.host.getPort());
        } else {
            ((DAVClient)((Object)this.client)).disablePreemptiveAuthentication();
        }
        if (this.host.getCredentials().isPassed()) {
            log.warn((Object)String.format("Skip verifying credentials with previous successful authentication event for %s", new Object[]{this}));
            return;
        }
        try {
            Path home = new DefaultHomeFinderService((Session)this).find();
            try {
                ((DAVClient)((Object)this.client)).execute((HttpRequestBase)new HttpHead(new DAVPathEncoder().encode(home)), new VoidResponseHandler());
            }
            catch (SardineException e) {
                switch (e.getStatusCode()) {
                    case 403: 
                    case 404: 
                    case 405: 
                    case 415: {
                        log.warn((Object)String.format("Failed HEAD request to %s with %s. Retry with PROPFIND.", this.host, e.getResponsePhrase()));
                        cancel.verify();
                        cache.put((Referenceable)home, ((ListService)this.getFeature(ListService.class)).list(home, (ListProgressListener)new DisabledListProgressListener(){

                            public void chunk(Path parent, AttributedList<Path> list) throws ListCanceledException {
                                try {
                                    cancel.verify();
                                }
                                catch (ConnectionCanceledException e) {
                                    throw new ListCanceledException(list, (Throwable)e);
                                }
                            }
                        }));
                        break;
                    }
                    case 400: {
                        if (this.preferences.getBoolean("webdav.basic.preemptive")) {
                            log.warn((Object)String.format("Disable preemptive authentication for %s due to failure %s", this.host, e.getResponsePhrase()));
                            cancel.verify();
                            ((DAVClient)((Object)this.client)).disablePreemptiveAuthentication();
                            ((DAVClient)((Object)this.client)).execute((HttpRequestBase)new HttpHead(new DAVPathEncoder().encode(home)), new VoidResponseHandler());
                            break;
                        }
                        throw new DAVExceptionMappingService().map((HttpResponseException)e);
                    }
                    default: {
                        throw new DAVExceptionMappingService().map((HttpResponseException)e);
                    }
                }
            }
        }
        catch (SardineException e) {
            throw new DAVExceptionMappingService().map((HttpResponseException)e);
        }
        catch (IOException e) {
            throw new HttpExceptionMappingService().map(e);
        }
    }

    public boolean alert(ConnectionCallback callback) throws BackgroundException {
        if (super.alert(callback)) {
            block6: {
                Path home = new DefaultHomeFinderService((Session)this).find();
                try {
                    RequestConfig context = ((DAVClient)((Object)this.client)).context().getRequestConfig();
                    HttpHead request = new HttpHead(new DAVPathEncoder().encode(home));
                    request.setConfig(RequestConfig.copy((RequestConfig)context).setRedirectsEnabled(false).build());
                    Header location = (Header)((DAVClient)((Object)this.client)).execute((HttpRequestBase)request, new ValidatingResponseHandler<Header>(){

                        public Header handleResponse(HttpResponse response) throws IOException {
                            if (response.getStatusLine().getStatusCode() == 301) {
                                return response.getFirstHeader("Location");
                            }
                            return null;
                        }
                    });
                    ((DAVClient)((Object)this.client)).context().setRequestConfig(RequestConfig.copy((RequestConfig)context).setRedirectsEnabled(true).build());
                    if (null == location) break block6;
                    URL url = new URL(location.getValue());
                    if (!StringUtils.equals((CharSequence)Scheme.https.name(), (CharSequence)url.getProtocol())) break block6;
                    try {
                        callback.warn(this.host.getProtocol(), MessageFormat.format(LocaleFactory.localizedString((String)"Unsecured {0} connection", (String)"Credentials"), this.host.getProtocol().getName()), MessageFormat.format("{0} {1}.", MessageFormat.format(LocaleFactory.localizedString((String)"The server supports encrypted connections. Do you want to switch to {0}?", (String)"Credentials"), new DAVSSLProtocol().getName()), LocaleFactory.localizedString((String)"Please contact your web hosting service provider for assistance", (String)"Support")), LocaleFactory.localizedString((String)"Continue", (String)"Credentials"), LocaleFactory.localizedString((String)"Change", (String)"Credentials"), String.format("connection.unsecure.%s", this.host.getHostname()));
                    }
                    catch (LoginCanceledException e) {
                        this.host.setHostname(url.getHost());
                        this.host.setProtocol((Protocol)new DAVSSLProtocol());
                        return false;
                    }
                }
                catch (SardineException e) {
                    log.warn((Object)String.format("Ignore failed HEAD request to %s with %s.", this.host, e.getResponsePhrase()));
                }
                catch (IOException e) {
                    throw new HttpExceptionMappingService().map(e);
                }
            }
            return this.preferences.getBoolean("webdav.basic.preemptive");
        }
        return false;
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        return new DAVListService(this).list(directory, listener);
    }

    public <T> T _getFeature(Class<T> type) {
        if (type == Directory.class) {
            return (T)new DAVDirectoryFeature(this);
        }
        if (type == Read.class) {
            return (T)new DAVReadFeature(this);
        }
        if (type == Write.class) {
            return (T)((Object)new DAVWriteFeature(this));
        }
        if (type == Upload.class) {
            return (T)((Object)new DAVUploadFeature(new DAVWriteFeature(this)));
        }
        if (type == Delete.class) {
            return (T)new DAVDeleteFeature(this);
        }
        if (type == Move.class) {
            return (T)new DAVMoveFeature(this);
        }
        if (type == Headers.class) {
            return (T)new DAVMetadataFeature(this);
        }
        if (type == Copy.class) {
            return (T)new DAVCopyFeature(this);
        }
        if (type == AttributesFinder.class) {
            return (T)new DAVAttributesFinderFeature(this);
        }
        if (type == Timestamp.class) {
            return (T)((Object)new DAVTimestampFeature(this));
        }
        if (type == Quota.class) {
            return (T)new DAVQuotaFeature(this);
        }
        if (type == Lock.class) {
            return (T)new DAVLockFeature(this);
        }
        if (type == Touch.class) {
            return (T)new DefaultTouchFeature((Upload)new DAVUploadFeature(new DAVWriteFeature(this)));
        }
        return (T)super._getFeature(type);
    }
}

