/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dav;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.date.RFC1123DateFormatter;
import ch.cyberduck.core.dav.DAVClient;
import ch.cyberduck.core.dav.DAVExceptionMappingService;
import ch.cyberduck.core.dav.DAVPathEncoder;
import ch.cyberduck.core.dav.DAVSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Timestamp;
import ch.cyberduck.core.shared.DefaultTimestampFeature;
import com.github.sardine.impl.SardineException;
import java.io.IOException;
import java.util.HashMap;
import java.util.TimeZone;
import javax.xml.namespace.QName;

public class DAVTimestampFeature
extends DefaultTimestampFeature
implements Timestamp {
    private final DAVSession session;

    public DAVTimestampFeature(DAVSession session) {
        this.session = session;
    }

    public void setTimestamp(Path file, Long modified) throws BackgroundException {
        try {
            HashMap<QName, String> props = new HashMap<QName, String>();
            props.put(new QName("DAV:", "lastmodified", "d"), new RFC1123DateFormatter().format(modified.longValue(), TimeZone.getTimeZone("UTC")));
            ((DAVClient)((Object)this.session.getClient())).patch(new DAVPathEncoder().encode(file), props);
        }
        catch (SardineException e) {
            throw new DAVExceptionMappingService().map("Failure to write attributes of {0}", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e, file);
        }
    }
}

